(() => {
  chrome.runtime.onMessage.addListener((obj, sender, response) => {
    try {
      const { type, err } = obj;

      console.log("err", err);

      if (type == "hasNotPermission") {
        updateDom(
          "You do not have permission to visit this website. If you believe this is an error, please take a screenshot of the full URL and contact IT support."
        );
      } else if (type == "hasError") {
        updateDom(err);
      }
    } catch (error) {
      alert(error);
    }
  });

  const deleteDom = () => {
    let dom = document.querySelector("body");

    dom.remove();
  };

  const updateDom = (err) => {
    let dom = document.querySelector("body");

    dom.innerHTML = `<div style="width: 100%;height: 100vh;text-align: center;align-items: center;display: flex;flex-direction: column; justify-content: center;">
    <img style="height: 150px; margin-bottom: 30px;" src="https://link.wakalaty.com/images/logo.png"/>
    ${
      err
        ? err
        : "please try to log out & login from the links website, if the error persists contact the IT support team!"
    } </div>`;
  };

  const checkPermission = () => {
    let site = location.host;
    let href = location.href;

    if (site.indexOf("www.") != -1) {
      site = site.substring(site.indexOf("www.") + 4);
    }

    if (location.host !== "link.wakalaty.com")
      chrome.runtime.sendMessage({
        type: "checkPermission",
        site: site,
        href: href,
      });
  };

  const SaveToken = async () => {
    if (location.host == "link.wakalaty.com") {
      chrome.runtime.sendMessage({
        type: "getCookies",
        location: location.host,
      });
    } else {
      checkPermission();
    }
  };

  SaveToken();
})();
