const BASE_URL = "https://link.api.wakalaty.com/api";

// chrome.tabs.onUpdated.addListener(async (tabId, t) => {
//   if (t && t.status == "complete") {
//     let queryOptions = { active: true, lastFocusedWindow: true };
//     let [tab] = await chrome.tabs.query(queryOptions);

//     if (tab && tab.url && tab.url.includes("dev.infinity.net")) {
//       chrome.tabs.sendMessage(tabId, {
//         type: "Login",
//       });
//     }
//   }
// });

chrome.runtime.onMessage.addListener(async function (
  request,
  sender,
  sendResponse
) {
  const getCookies = async (location) => {
    const cookies = await chrome.cookies.getAll({
      domain: location,
      name: "auth_token",
    });

    console.log(cookies);

    if (cookies[0]) storeTokenSession(cookies[0].value);
    else removeOldTokenSession();
  };

  const hasAccess = async (site, href) => {
    var token;
    await chrome.storage.local.get(["token"]).then((result) => {
      token = result.token;
    });

    if (!token)
      return {
        error: true,
        message: "please visit the links website, login & refresh the page",
      };

    let data;
    try {
      await fetch(BASE_URL + `/sites/${btoa(site)}`, {
        method: "POST",
        headers: {
          Accept: "application/json",
          token: token,
        },
        body: JSON.stringify({ href: href }),
      })
        .then((response) => response.json())
        .then(async (response) => {
          data = response;
        });
    } catch (error) {
      return { error: true, message: error };
    }

    return { access: data.access };
  };

  const storeTokenSession = (token) => {
    chrome.storage.local.set({ token: token }).then(() => {
      console.log("Value is set");
    });
  };

  const removeOldTokenSession = () => {
    chrome.storage.local.set({ token: null }).then(() => {
      console.log("Value is removed");
    });
  };

  if (request.type == "checkPermission") {
    let data = await hasAccess(request.site, request.href);

    let queryOptions = { active: true, lastFocusedWindow: true };
    let [tab] = await chrome.tabs.query(queryOptions);

    chrome.tabs.sendMessage(tab.id, {
      type: data.access
        ? "hasPermission"
        : data.error
        ? "hasError"
        : "hasNotPermission",
      err: data.message,
    });
  } else if (request.type == "getCookies") {
    await getCookies(request.location);
  }
});
