(() => {
  chrome.runtime.onMessage.addListener((obj, sender, response) => {
    try {
      const { type } = obj;

      if (type == "hasNotPermission") {
        deleteDom();
      }
    } catch (error) {
      alert(error);
    }
  });

  const deleteDom = () => {
    let dom = document.querySelector("body");

    dom.remove();
  };

  const checkPermission = () => {
    let site = location.host;
    let href = location.href;

    if (site.indexOf("www.") != -1) {
      site = site.substring(site.indexOf("www.") + 4);
    }

    if (location.host !== "link.wakalaty.com")
      chrome.runtime.sendMessage({
        type: "checkPermission",
        site: site,
        href: href,
      });
  };

  const SaveToken = async () => {
    if (location.host == "link.wakalaty.com") {
      chrome.runtime.sendMessage({
        type: "getCookies",
        location: location.host,
      });
    } else {
      checkPermission();
    }
  };

  SaveToken();
})();
